// GMSH script to generate the mesh for the 3d perforated plate
// Documentation: https://gmsh.info/doc/texinfo/gmsh.html
// Design from: CodeAster validation manual (https://code-aster.org/V2/doc/default/fr/man_v/v4/v4.23.301.pdf)
// Author: Andrea Pavan
// Date: 06/01/2023


//parameters
Dfuel = 1.27e-2;		//fuel rod diameter
Dcoolant = 1.587e-2;		//coolant rod diameter
L = 1.879e-2;		//distance between fuel and coolant centers
h = 0.1e-2;		//domain height

surfaceMeshSize = 0.02e-2;		//mesh size at the boundaries


//change geometry kernel
SetFactory("OpenCASCADE");


//-----------------------
//  geometry creation
//-----------------------

Point(1) = {0, 0, 0, surfaceMeshSize};
Point(2) = {Dfuel/2, 0, 0, surfaceMeshSize};		//point A
Point(3) = {0.5*L, 0, 0, surfaceMeshSize};		//point B
Point(4) = {0.5*L, 0.5*Sqrt(3)*L - Dcoolant/2, 0, surfaceMeshSize};		//point E
Point(5) = {0.5*L, 0.5*Sqrt(3)*L, 0, surfaceMeshSize};
Point(6) = {0.5*L + 0.5*Dcoolant*Cos(-120*Pi/180), 0.5*Sqrt(3)*L + 0.5*Dcoolant*Sin(-120*Pi/180), 0, surfaceMeshSize};		//point D
Point(7) = {0.5*Dfuel/2, 0.5*Sqrt(3)*Dfuel/2, 0, surfaceMeshSize};		//point C

Line(1) = {2, 3};
Line(2) = {3, 4};
Circle(3) = {4, 5, 6};
Line(4) = {6, 7};
Circle(5) = {7, 1, 2};

Curve Loop(1) = {1, 2, 3, 4, 5};
Plane Surface(1) = {1};
Extrude {0, 0, h} {
  Curve{1}; Curve{2}; Curve{3}; Curve{4}; Curve{5}; 
}
Curve Loop(7) = {8, 10, 12, 14, 15};
Plane Surface(7) = {7};
Surface Loop(1) = {7, 2, 6, 5, 4, 3, 1};
Volume(1) = {1};
